/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Ac                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of asymmetry parameter of charms                               *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_Ac
#define GSTU_Ac

#include "Gfitter/GTheory.h"




namespace GSTU {

   class Alep;
   class A0cFB;

   class Ac : public Gfitter::GTheory {

   public:
      
      Ac();
      ~Ac() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:

      // reference to Alep
      Alep& GetAlep() const { return (Alep&)*t_Alep; }      
      Gfitter::GTheoryRef    t_Alep; 

      // reference to A0cFB
      A0cFB& GetA0cFB() const { return (A0cFB&)*t_A0cFB; }      
      Gfitter::GTheoryRef    t_A0cFB; 
      
      ClassDef(Ac,0)
   };
}

#endif
