/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Alep                                                                  *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source:                                                                        *
 *      - C. P. Burgess, Pramana 45 , S47 (1995), [arXiv:hep-ph/9411257]          *
 *        (see also references)                                                   *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GSTU/Alep.h"

ClassImp(GSTU::Alep)

GSTU::Alep::Alep(): SMPredictions(){}

Double_t GSTU::Alep::GetTheoryPrediction()
{
   Update();
      // see table 1 from hep-ph/9411257
   Double_t retVal = GetSM_Alep() - 0.0284*GetS() + 0.0201*GetT() - 0.0613*GetX();
   
   return retVal;
}
