/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Delta_eHad                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Sources:                                                                       *
 *      - R. Contino, L. Pilo, R. Rattazzi and A. Strumia                         *
 *        JHEP 0106, 005 (2001), [arXiv:hep-ph/0103104]                           *
 *      - [ADLO+SLD], Phys. Rept. 427, 257 (2006), [arXiv:hep-ex/0509008]         *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/
#include "Gfitter/GConstants.h"
#include "Gfitter/GVariable.h"
#include "Gfitter/GStore.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GReference.h"

#include "GSTU/Delta_eHad.h"

#include "TMath.h"

using namespace Gfitter;

ClassImp(GSTU::Delta_eHad)


GSTU::Delta_eHad::Delta_eHad(): SMPredictions()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookTheory( "GEW::DAlphaQED", &t_DAlphaQED );
}

// for reference see hep-ph/0103104 page 25-26
Double_t GSTU::Delta_eHad::GetTheoryPrediction()
{
   Update(); 

   Double_t alphaMZ = GConstants::alphaQED()/(1. - GetDAlphaQED().DAlphaQEDMZt() );

   // eq. (7.13) from hep-ex/0509008 
   Double_t s02    = 0.5*( 1. - TMath::Sqrt(1.-4.*(TMath::Pi())*alphaMZ/(TMath::Sqrt(2.)*p_GF*p_MZ*p_MZ)) );
   Double_t c02    = 1.0 - s02; 
  
   Double_t delta_e = alphaMZ*(GetT() + 1/(4.*s02)*GetU() - 1/(4.*c02)*GetS());

   return delta_e;
}
