/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Delta_eHad                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Estimate of the ratio betwenn cut-off and MD                              *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_Delta_eHad
#define GSTU_Delta_eHad

#include "GSTU/SMPredictions.h"
#include "GEW/DAlphaQED.h"

namespace GSTU {

   class Delta_eHad : public SMPredictions {

   public:
      
      Delta_eHad();
      ~Delta_eHad() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      // reference to DAlphaQED
      GEW::DAlphaQED& GetDAlphaQED() const { return (GEW::DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef t_DAlphaQED; 

      ClassDef(Delta_eHad,0)
   };
}

#endif
