/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : ExtraFamilies                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      STU electroweak corrections of 4th generation                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GSTU_ExtraFamilies
#define GSTU_ExtraFamilies

#include "GSTU/TheoryBase.h"

#include "GEW/MW.h"






namespace GSTU {

   class MW;

   class ExtraFamilies : public TheoryBase {

   public:
     
      ExtraFamilies();
      virtual ~ExtraFamilies() {}

      Double_t GetS();
      Double_t GetT();
      Double_t GetU();
      
      // are set to zero in this model
      Double_t GetV(){ return 0; };
      Double_t GetW(){ return 0; };
      Double_t GetX(){ return 0; };
         
      // additional corrections to Z->bb couplings
      Double_t Get_deltagLb(){ return 0; };
      Double_t Get_deltagRb(){ return 0; };

      // Initialise coefficients
      void Initialise();

   protected:
     
      // auxiliary functions
      Double_t F(Double_t x, Double_t y);
      Double_t f(Double_t x, Double_t y);
      Double_t G(Double_t x);
      Double_t SPar(Double_t M1, Double_t M2, Double_t Y, Double_t Nc);
      Double_t TPar(Double_t M1, Double_t M2, Double_t Y, Double_t Nc);
      Double_t UPar(Double_t M1, Double_t M2, Double_t Y, Double_t Nc);

      void AvoidUnphysicalValues();

      // parameters
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_mUp4;
      Gfitter::GParameterRef p_mNeutrino4;
      // if m_AbsMass == true
      Gfitter::GParameterRef p_mLepton4;
      Gfitter::GParameterRef p_mDown4;
      // if m_AbsMass == false
      Gfitter::GParameterRef p_mNeutrino4MinusLepton4;
      Gfitter::GParameterRef p_mUp4MinusDown4;
      
      // reference to MW
      GEW::MW& GetMW() const { return (GEW::MW&)*t_MW; }      
      Gfitter::GTheoryRef t_MW; 
      
      // Choice of parameters
      Bool_t m_AbsMass;
      
      // Enabling and desabling Quark and Lepton contributions
      Bool_t m_FourthLepton;
      Bool_t m_FourthQuark;
      
      ClassDef(ExtraFamilies,0)
         };
}

#endif
 
