/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : GammaWtot                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source:                                                                        *
 *      - C. P. Burgess, Pramana 45 , S47 (1995), [arXiv:hep-ph/9411257]          *
 *        (see also references)                                                   *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/
#include "GSTU/GammaWtot.h"

ClassImp(GSTU::GammaWtot)

GSTU::GammaWtot::GammaWtot(): SMPredictions(){}

Double_t GSTU::GammaWtot::GetTheoryPrediction()
{
   Update();
   
   // see table 1 from hep-ph/9411257
   Double_t retVal = GetSM_GammaWtot()*( 1. - 0.00723*GetS() + 0.0111*GetT() 
                                         + 0.00849*GetU() + 0.00781*GetW() ); 
   
   return retVal;
}
