/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : GammaZtot                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of total Z width                                               *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_GammaZtot
#define GSTU_GammaZtot

#include "GSTU/SMPredictions.h"

namespace GSTU {

   class GammaZtot : public SMPredictions {

   public:
      
      GammaZtot();
      ~GammaZtot() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      ClassDef(GammaZtot,0)
   };
}

#endif
