/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : IDM_Constraint1                                                       *
 *                                                                                *
 * Description:                                                                   *
 *     - 2*ML+Delta_M > MZ or ML + MA0 > MZ                                       *
 *     - in order to Z-decay into two higgs states                                *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "GSTU/IDM_Constraint1.h"

#include "Gfitter/GTheory.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GReference.h"

#include "TMath.h"

using namespace Gfitter;

ClassImp(GSTU::IDM_Constraint1)


GSTU::IDM_Constraint1::IDM_Constraint1(): Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "MZ",     &p_MZ );
   BookParameter( "ML",     &p_ML );
   BookParameter( "DeltaM", &p_DeltaM );
}

Double_t GSTU::IDM_Constraint1::GetTheoryPrediction()
{
   return 2.*p_ML + p_DeltaM - p_MZ;
}
