/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : LED_EWConstraint                                                      *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source:                                                                        *
 *      - R. Contino, L. Pilo, R. Rattazzi and A. Strumia                         *
 *        JHEP 0106, 005 (2001), [arXiv:hep-ph/0103104]                           *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/
#include "Gfitter/GConstants.h"
#include "Gfitter/GVariable.h"
#include "Gfitter/GStore.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GReference.h"

#include "GSTU/LED_EWConstraint.h"

#include "TMath.h"

using namespace Gfitter;

ClassImp(GSTU::LED_EWConstraint)


   GSTU::LED_EWConstraint::LED_EWConstraint(): Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookTheory( "GSTU::Delta_eHad",     &t_stu );
   BookTheory( "GSTU::LED_Delta_eHad", &t_led );
}

// for references see hep-ph/0103104v2 page 25-26
Double_t GSTU::LED_EWConstraint::GetTheoryPrediction()
{
   double led = GetLEDPred();
   double stu = GetSTUPred();

   return (led-stu)/stu;
}
