/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : LittlestHiggs                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      STU electroweak corrections from the Littlest Higgs model                 *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_LittlestHiggs
#define GSTU_LittlestHiggs

#include "GSTU/TheoryBase.h"

#include "GEW/MW.h"






namespace GSTU {

   class LHmtplus;
   
   class LittlestHiggs : public TheoryBase {

   public:
      
      LittlestHiggs();
      virtual ~LittlestHiggs() {}

      Double_t GetS();
      Double_t GetT();
      Double_t GetU();
      // are set to zero in this model
      Double_t GetV(){ return 0; };
      Double_t GetW(){ return 0; };
      Double_t GetX(){ return 0; };

      // additional corrections to Z->bb couplings 
      Double_t Get_deltagLb();
      Double_t Get_deltagRb(){ return 0; };

      // Initialise coefficients
      void Initialise();

   protected:
      
      // parameters

      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_mt;
      // ratio between T-odd and T-even mass from top sector
      Gfitter::GParameterRef p_slambda;
      // order-one coefficient, 
      // exact value depends on the details of the UV physics 
      Gfitter::GParameterRef p_deltac;
      // symmetry breaking scale 
      Gfitter::GParameterRef p_f;
      // contribution to T parameter due to T_odd partners of light fermion
      Gfitter::GParameterRef p_Tfermions;
      // number of light fermion doublets in SM
      Gfitter::GParameterRef p_Ndoublets;

      // mass of top partner (T-even)
      LHmtplus& Get_mtplus() const { return (LHmtplus&)*t_mtplus; }      
      Gfitter::GTheoryRef t_mtplus;

      // reference to MW
      GEW::MW& GetMW() const { return (GEW::MW&)*t_MW; }      
      Gfitter::GTheoryRef t_MW; 

      ClassDef(LittlestHiggs,0)
   };
}

#endif
