/**********************************************************************************
 * Project: GSTU - GSTU Parameter fitting package                                 *
 * Package: GSTU                                                                  *
 * Class  : MH0gmh                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      SUSY helper class                                                         *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GSTU_MH0gmh
#define GSTU_MH0gmh

#include "Gfitter/GTheory.h"

namespace Gfitter {
   class GParameterRef;
   class GTheoryRef;
   class GReference;
}

namespace GSTU 
{
   class MH0gmh : public Gfitter::GTheory {
  
   public:
  
      MH0gmh();
      ~MH0gmh() {}
    
      /// Theory Prediction
      Double_t GetTheoryPrediction();
    
      /// Initialise coefficients
      void Initialise() ;
    
   protected:
  
      /// update of flags in case of parameter change
      void UpdateLocalFlags( Gfitter::GReference& ref );
    
      /// update parameters
      void Update();
    
      /// references to other parameters
      Gfitter::GParameterRef p_MH0;
      Gfitter::GParameterRef p_MH;
    
      Bool_t m_isUpToDate_Update;
      Double_t m_value;

   private:

      ClassDef(MH0gmh,0)
         };
}

#endif
