/**********************************************************************************
 * Project: GSTU - GSTU Parameter fitting package                                 *
 * Package: GSTU                                                                  *
 * Class  : MHchgmh                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      SUSY helper class                                                         *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "GSTU/MHchgmh.h"
#include "Gfitter/GReference.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GMsgLogger.h"


ClassImp(GSTU::MHchgmh)

using namespace Gfitter;

GSTU::MHchgmh::MHchgmh()
 : Gfitter::GTheory()
 , m_isUpToDate_Update(kFALSE)
 , m_value(-999.)
{
  SetTheoryName( GetName() );
  SetExistDerivative( kFALSE );
  
  Initialise();

  /// Book your parameters and theories here below
  
  BookParameter ( "MHcharge", &p_MHch );
  BookParameter ( "MH", &p_MH );
}


void GSTU::MHchgmh::Initialise() 
{
   /// Initialization goes here
}


void GSTU::MHchgmh::UpdateLocalFlags( Gfitter::GReference& /*ref*/ )
{
   m_isUpToDate_Update = kFALSE;
}


void GSTU::MHchgmh::Update()
{
   if(m_isUpToDate_Update) return;  
   m_isUpToDate_Update = kTRUE;
  
   /// your parameter updates here
   m_value = p_MHch-p_MH;

   SetUpToDate(); 
}


Double_t GSTU::MHchgmh::GetTheoryPrediction()
{
   /// your theory prediction goes here
   Update();

   return m_value;
}

