/**********************************************************************************
 * Project: GSTU - GSTU Parameter fitting package                                 *
 * Package: GSTU                                                                  *
 * Class  : MHchgmh                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      SUSY helper class                                                         *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GSTU_MHchgmh
#define GSTU_MHchgmh

#include "Gfitter/GTheory.h"

namespace Gfitter {
   class GParameterRef;
   class GTheoryRef;
   class GReference;
}

namespace GSTU 
{
   class MHchgmh : public Gfitter::GTheory {
  
   public:
  
      MHchgmh();
      ~MHchgmh() {}
    
      /// Theory Prediction
      Double_t GetTheoryPrediction();
    
      /// Initialise coefficients
      void Initialise() ;
    
   protected:
  
      /// update of flags in case of parameter change
      void UpdateLocalFlags( Gfitter::GReference& ref );
    
      /// update parameters
      void Update();
    
      /// references to other parameters
      Gfitter::GParameterRef p_MH;
      Gfitter::GParameterRef p_MHch;    

      Bool_t m_isUpToDate_Update;
      Double_t m_value;

   private:

      ClassDef(MHchgmh,0)
         };
}

#endif
