/**********************************************************************************
 * Project: GSTU - GSTU Parameter fitting package                                 *
 * Package: GSTU                                                                  *
 * Class  : NanPenalty                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Implemantation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/

#include "GSTU/NanPenalty.h"
#include "Gfitter/GReference.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GMsgLogger.h"
#include "TMath.h"
#include "Gfitter/GInterval.h"

ClassImp(GSTU::NanPenalty)

using namespace Gfitter;

GSTU::NanPenalty::NanPenalty()
 : Gfitter::GTheory()
 , m_isUpToDate_Update(kFALSE)
 , m_value(-999.)
{
  SetTheoryName( GetName() );
  SetExistDerivative( kFALSE );
  
  Initialise();
}


void GSTU::NanPenalty::Initialise() 
{
  /// Initialization goes here
}


void GSTU::NanPenalty::UpdateLocalFlags( Gfitter::GReference& /*ref*/ )
{
  m_isUpToDate_Update = kFALSE;
}


void GSTU::NanPenalty::Update()
{
  if(m_isUpToDate_Update) return;  
  m_isUpToDate_Update = kTRUE;
 
  m_value = 0.0;

  GParPtrVec_t::const_iterator par;
  const GParPtrVec_t& v = gStore()->GetActiveParameters();
 
  for (par = v.begin(); par != v.end(); par++) {
     Double_t value;
     if (!(*par)->HasTheory()) value = (*par)->GetFitValue();
     else                      value = (*par)->GetTheoryPrediction();

     if (TMath::IsNaN( value )) {

         m_logger << kINFO << "Fit par " << (*par)->GetFullName()
                  << "\" initial value (v/fit): ("
                  << (*par)->GetValue() << "/" << value << ")"
                  << ", fit range: [" << (*par)->GetFitRange().GetMin() << ", "
                  << (*par)->GetFitRange().GetMax() << "]"
                  << ", fit step: " << (*par)->GetFitStep()
                  << ", chi2: " << (*par)->GetChiSquared()
                  << GEndl;

       m_logger << kWARNING << "NAN for parameter : " << (*par)->GetName() << GEndl; 
       m_value += 1.;
     }
  }

  SetUpToDate(); 
}


Double_t 
GSTU::NanPenalty::GetTheoryPrediction()
{
  /// your theory prediction goes here
  Update();

  return m_value;
}

