/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : R0lep                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of ratio between hadronic and leptonic Z width                 *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_R0lep
#define GSTU_R0lep

#include "GSTU/SMPredictions.h"

namespace GSTU {

   class R0lep : public SMPredictions {

   public:
      
      R0lep();
      ~R0lep() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      ClassDef(R0lep,0)
   };
}

#endif
