/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : RandallSundrum_CustSym                                                *
 *                                                                                *
 * Description:                                                                   *
 *      STU electroweak corrections from the Randall-Sundrum model                *
 *                         (!) with gauge and matter fields in the bulk (!)       *
 *                             with custodial SU(2)R symmetry                     *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_RandallSundrum_CustSym
#define GSTU_RandallSundrum_CustSym

#include "GSTU/TheoryBase.h"
#include "GEW/MW.h"






namespace GSTU {

   class RandallSundrum_CustSym : public TheoryBase {

   public:
      
      RandallSundrum_CustSym();
      virtual ~RandallSundrum_CustSym() {}

      Double_t GetS();
      Double_t GetT();
      // are set to zero in this model
      Double_t GetU(){ return 0; };
      Double_t GetV(){ return 0; };
      Double_t GetW(){ return 0; };
      Double_t GetX(){ return 0; };
         
      // additional corrections to Z->bb couplings 
      Double_t Get_deltagLb(){ return 0; };
      Double_t Get_deltagRb(){ return 0; };

      // Initialise coefficients
      void Initialise();

   protected:
      
      // parameters
      Gfitter::GParameterRef p_MZ;

      // mass of Kaluza-Klain state
      Gfitter::GParameterRef p_MKK;

      // logrithm of the warp factor
      Gfitter::GParameterRef p_L;
        
      // reference to MW
      GEW::MW& GetMW() const { return (GEW::MW&)*t_MW; }      
      Gfitter::GTheoryRef t_MW; 
      
      ClassDef(RandallSundrum_CustSym,0)
         };
}

#endif
