/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : SMPredictions                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      SM predictions                                                            *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_SMPredictions
#define GSTU_SMPredictions

#include "GSTU/TheoryHandler.h"

#include "GEW/MW.h"
#include "GEW/R0bParametrisation.h"
#include "GEW/Z0Base.h"
#include "GEW/WBase.h"



   
namespace GSTU {

   class SMPredictions : public TheoryHandler {

   public:
      
      SMPredictions();
      ~SMPredictions() {}

   protected:

      // update of flags in case of parameter change
      void UpdateLocalFlags( Gfitter::GReference& ref );
   
      // update parameters
      void Update();

      // including STU corrections
      Double_t GetSTU_GammaZtot() { return checkNaN(m_STUGammaZtot,2.4952); } // MB: NaN protection
      Double_t m_STUGammaZtot;

      Double_t GetSTU_Sigma0had() { return m_STUSigma0had; }
      Double_t m_STUSigma0had;
      
      Double_t GetSTU_R0b() { return m_STUR0b; }
      Double_t m_STUR0b;
      
      Double_t GetSTU_R0c() { return m_STUR0c; }
      Double_t m_STUR0c;
      
      Double_t GetSTU_R0lep() { return m_STUR0lep; }
      Double_t m_STUR0lep;
  
      // SM Predictions
      Double_t GetSM_A0bFB() { return checkNaN(m_SMA0bFB,0.1152); } // MB: NaN protection
      Double_t m_SMA0bFB;

      Double_t GetSM_A0cFB() { return checkNaN(m_SMA0cFB,0.1057); } // MB: NaN protection
      Double_t m_SMA0cFB;

      Double_t GetSM_A0lepFB() { return checkNaN(m_SMA0lepFB,0.0271); } // MB: NaN protection
      Double_t m_SMA0lepFB;

      Double_t GetSM_Alep() { return checkNaN(m_SMAlep,0.170); } // MB: NaN protection
      Double_t m_SMAlep;

      Double_t GetSM_GammaWtot() { return m_SMGammaWtot; }
      Double_t m_SMGammaWtot;

      Double_t GetSM_GammaZtot() { return m_SMGammaZtot; }
      Double_t m_SMGammaZtot;

      GEW::MW& GetSM_MW() { return (GEW::MW&)*t_SMMW; }
      Gfitter::GTheoryRef t_SMMW;
     
      GEW::R0bParametrisation& GetR0bPara() { return (GEW::R0bParametrisation&)*t_SMR0b; }
      Gfitter::GTheoryRef t_SMR0b;
 
      GEW::Z0Base& GetSM_Z0Theory() { return (GEW::Z0Base&)*t_SMz0Theory; }
      Gfitter::GTheoryRef t_SMz0Theory;

      GEW::WBase& GetSM_WTheory() const { return (GEW::WBase&)*t_SMwTheory; }  
      Gfitter::GTheoryRef t_SMwTheory;      
      
      // SM parameter (needed for Sigma0had and W width)
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_GF;
     
   private:

      // boolean flags to track recomputation
      Bool_t m_isUpToDate_Update; 
      
      Bool_t m_fullTwoLoop4R0b;
      
      ClassDef(SMPredictions,0)
   };
}

#endif
