/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : SinEffLep                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/
#include "TMath.h"

#include "GSTU/SinEffLep.h"
#include "GSTU/Alep.h"

ClassImp(GSTU::SinEffLep)

   GSTU::SinEffLep::SinEffLep(): Gfitter::GTheory()
{
   BookTheory   ( "GSTU::Alep",  &t_Alep  );   
}

Double_t GSTU::SinEffLep::GetTheoryPrediction()
{
   Double_t x = TMath::Sqrt(1.0/TMath::Power(GetAlep(),2) - 1.0);

   Double_t retVal = 1/4.0 * (1.0 - 1.0/GetAlep() + x);
   
   return retVal;
}
