/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : SinEffLep                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of eff. weak mixing angle                                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_SinEffLep
#define GSTU_SinEffLep

#include "Gfitter/GTheory.h"




namespace GSTU {

   class Alep;

   class SinEffLep : public Gfitter::GTheory {

   public:
      
      SinEffLep();
      ~SinEffLep() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:

      // reference to Alep
      Alep& GetAlep() const { return (Alep&)*t_Alep; }      
      Gfitter::GTheoryRef    t_Alep; 

      ClassDef(SinEffLep,0)
   };
}

#endif
