/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : T_Theory                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Theory Prediction of T parameter                                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_T_Theory
#define GSTU_T_Theory

#include "GSTU/TheoryHandler.h"

namespace GSTU {

   class T_Theory : public TheoryHandler {

   public:
      
      T_Theory();
      ~T_Theory() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      ClassDef(T_Theory,0)
         };
}

#endif
