/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : TechniColor                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      STU electroweak corrections from the Technicolor model                    *
 *                         (!) with gauge and matter fields in the bulk (!)       *
 *                             without custodial SU(2)R symmetry                  *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_TechniColor
#define GSTU_TechniColor

#include "GSTU/TheoryBase.h"
#include "GEW/MW.h"






namespace GSTU {

   class TechniColor : public TheoryBase {

   public:
      
      TechniColor();
      virtual ~TechniColor() {}

      Double_t GetS();
      Double_t GetT();
      // are set to zero in this model
      Double_t GetU();
      Double_t GetV(){ return 0; };
      Double_t GetW(){ return 0; };
      Double_t GetX(){ return 0; };
         
      // additional corrections to Z->bb couplings 
      Double_t Get_deltagLb(){ return 0; };
      Double_t Get_deltagRb(){ return 0; };

      // Initialise coefficients
      void Initialise();

   protected:
      
      // parameters
      Gfitter::GParameterRef p_MZ;

      // Masses of Doublets
      Gfitter::GParameterRef p_TechniElectronMass;
	Gfitter::GParameterRef p_TechniLeptonMassRatio;

      // SU(N_TC)
      Gfitter::GParameterRef p_NTC;

	// Model for Dirac ot Majorana Particles
	Gfitter::GParameterRef p_DiracMajoranaModel;
	
	// Weak Hypercharge of (N,E) Doublet
      Gfitter::GParameterRef p_TCWeakHyperCharge;
        
      // reference to MW
      GEW::MW& GetMW() const { return (GEW::MW&)*t_MW; }      
      Gfitter::GTheoryRef t_MW; 
      
      ClassDef(TechniColor,0)
         };
}

#endif
