/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : TheoryBase                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Theory Builder                                                            *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_TheoryBase
#define GSTU_TheoryBase

#include "Gfitter/GAuxTheory.h"
#include "Gfitter/GTypes.h"

namespace GSTU {

   class TheoryBase : public Gfitter::GAuxTheory {

   public:
      
      TheoryBase();
      virtual ~TheoryBase() {}

      // STU corretions
      virtual Double_t GetS() = 0;
      virtual Double_t GetT() = 0;
      virtual Double_t GetU() = 0;
      virtual Double_t GetV() = 0;
      virtual Double_t GetW() = 0;
      virtual Double_t GetX() = 0;

      // additional corrections to Z->bb couplings 
      virtual Double_t Get_deltagLb() = 0;
      virtual Double_t Get_deltagRb() = 0;

   protected:
      
      ClassDef(TheoryBase,0)
   };
}

#endif
