/**********************************************************************************
 * Project: Gfitter - a Root-integrated toolkit for multivariate data analysis    *
 * Package: Gfitter                                                               *
 * Class  : GTheory                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 **********************************************************************************/

#include <iostream>
#include "Riostream.h"
#include "Gfitter/GParameterRef.h"
#include "GTest/Obs_Beta.h"

ClassImp(GTest::Obs_Beta)

GTest::Obs_Beta::Obs_Beta() 
   : Gfitter::GTheory()
{
   SetTheoryName( GetClassName() );
   SetExistDerivative( kFALSE );
   
   BookParameter("Beta", &m_Beta);
   BookParameter("alpha", &m_alpha);
}

Double_t GTest::Obs_Beta::GetTheoryPrediction() 
{ 
  return m_alpha != 0 ? m_Beta / m_alpha : 0;
}
