# setup ROOT
# check Root environment setup. Allow for external setup script.

export BUILD="x86_64-slc6-gcc46-opt"
export ROOTVERSION="5.34.08"
export CERNPREFIX="/afs/cern.ch/"

# Must have gcc and python setup outside of ROOTSYS def for batch running!
# This section here is cern specific.
if [[ `hostname --long` = l*cern.ch ]]; then 
    #don't check for *.cern.ch - any machine at CERN, incl. your laptop, has that hostname!
    echo "INFO: hostname matches l*.cern.ch: setting up gcc and python from afs"
    # first, setup gcc to version 4.6
    echo "Setting up gcc version 4.6 ..."
    source $CERNPREFIX/sw/lcg/external/gcc/4.6/x86_64-slc6/setup.sh
    # second, setup an uptodate python version
    echo "Setting up python version 2.7.2 ..."
    export PATH="$CERNPREFIX/sw/lcg/external/Python/2.7.2/$BUILD/bin:${PATH}"
    export LD_LIBRARY_PATH="$CERNPREFIX/sw/lcg/external/Python/2.7.2/$BUILD/lib:${LD_LIBRARY_PATH}"
fi

# the root-setup section here is cern specific
if [ ! $ROOTSYS ]; then
  echo "Setting up ROOT ${ROOTVERSION} ..."
  echo "With build ${BUILD} ..."
  export CWD=$PWD
  # setup corresponding root
  cd $CERNPREFIX/sw/lcg/app/releases/ROOT/$ROOTVERSION/$BUILD/root/
  source bin/thisroot.sh
  cd $CWD
  # setup xrootd on top of this
  export PATH=$CERNPREFIX/sw/lcg/external/xrootd/3.1.0p2/$BUILD/bin:$PATH
  export LD_LIBRARY_PATH=$CERNPREFIX/sw/lcg/external/xrootd/3.1.0p2/$BUILD/lib64:$LD_LIBRARY_PATH
  # missing libraries on lxbatch machines
  export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$CERNPREFIX/atlas/offline/external/FullChainTest/tier0/test/mbaak/root/extlibs64
fi

# check Root environment setup 
if [ ! $ROOTSYS ]; then
  echo "Warning: No valid Root environment (ROOTSYS) defined. Please do so first!"
  return
fi

if [ ! $LD_LIBRARY_PATH ]; then
  echo "Warning: so far you haven't setup your ROOT enviroment properly (no LD_LIBRARY_PATH)"
  return
fi


