#! /bin/csh

mkdir -p include; 
cd include;
if ( ! -l Gfitter ) then
    ln -s ../src Gfitter
endif
if ( ! -l GSUSY ) then
    ln -s ../gsusy GSUSY
endif
if ( ! -l GTEST ) then
    ln -s ../gtest GTEST
endif
if ( ! -l G2HDM ) then
    ln -s ../g2hdm G2HDM
endif
if ( ! -l GOblique ) then
    ln -s ../goblique GOblique
endif
if ( ! -l GSTU ) then
    ln -s ../gstu GSTU
endif
if ( ! -l GEW ) then
    ln -s ../gew GEW
endif
if ( ! -l GSM ) then
    ln -s ../gsm GSM
endif
if ( ! -l GHiggsCouplings ) then
    ln -s ../ghiggscouplings/ GHiggsCouplings
endif

cd -

# check Root environment setup
if !($?ROOTSYS) then
  echo "Warning: Root environment (ROOTSYS) not yet defined. Please do so! "
endif

if ($?LD_LIBRARY_PATH) then
  setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:$HOME/Gfitter/lib:$PWD/../lib:$PWD/lib
else 
  setenv LD_LIBRARY_PATH $HOME/Gfitter/lib:$PWD/../lib:$PWD/lib:$PWD/lib
  echo "Warning: so far you haven't setup your ROOT enviroment properly (no LD_LIBRARY_PATH): Gfitter will not work"
endif
