/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GAuxTheory                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Abstract base class for theory                                            *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GAuxTheory
#define Gfitter_GAuxTheory

#include <iostream>
#include "Gfitter/GTheoryBase.h"

namespace Gfitter { class GAuxTheory; }
ostream& operator<< ( ostream& os, const Gfitter::GAuxTheory& theory );

namespace Gfitter {

   class GAuxTheory : public GTheoryBase {
    
   public:
     
      // default constructor
      GAuxTheory();

      // constructor for simple formula parser
      GAuxTheory( const TString& name, const TString& formula );

      // destructor
      virtual ~GAuxTheory();

   protected:

      void UpdateLocalFlags( GReference & ) {}

      ClassDef(GAuxTheory,0)
   };
}

#endif
