/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GCornerSimplex                                                        * 
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "Gfitter/GCornerSimplex.h"
#include "Gfitter/GVariable.h"
#include "Gfitter/GInterval.h"
#include "Gfitter/GParameter.h"
#include "TRandom.h"

using namespace std;

ClassImp(Gfitter::GCornerSimplex)

Gfitter::GCornerSimplex::GCornerSimplex() 
   : GGSLMinimizer("Minuit2","Simplex")
{
   InitClassName( "GCornerSimplex" );
}

Gfitter::GCornerSimplex::~GCornerSimplex()
{
}

void
Gfitter::GCornerSimplex::Initialise()
{
   GGSLMinimizer::Initialise();

   // Randomize starting values?
   if (gStore()->ExistVariable( m_myname+"::DoCornerPoints" )) {
      m_doCorner = gStore()->GetVariable( m_myname+"::DoCornerPoints" )->GetBoolValue();
   }

   // set pre- and postfit scan
   m_doPrefitScan  = false;
   m_doPostfitScan = true;
}

void
Gfitter::GCornerSimplex::setInitValues()
{
  std::vector<ROOT::Fit::ParameterSettings>& parameters = _theFitter->Config().ParamsSettings();

  // apply randomization
  for (Int_t ipar=0; ipar < GetNumOfFitPars(); ++ipar) {
    const GInterval* pfs = GetFitPars()[ipar]->GetPreFitScanRange();
    if (pfs) {
      Double_t min   = pfs->GetMin();
      Double_t width = pfs->GetWidth();
      Double_t x     = min + m_random->Uniform()*width;
      GetFitPars()[ipar]->SetFitValue( x );
      parameters[ipar].SetValue( x ); // initialize the fit here
      m_logger << kINFO << ">> " << GetFitPars()[ipar]->GetParName() << " initial value = " << x << GEndl; 
    }
  }
}

