/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GDCardInterpreterBase                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Data card Interpreter abstract base class                                 *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GDCardInterpreterBase
#define Gfitter_GDCardInterpreterBase

#include "TROOT.h"
#include "TList.h"

#include "Gfitter/GObject.h"
#include "Gfitter/GScalerBase.h"

namespace Gfitter {

   class GStringList;

   class GDCardInterpreterBase;
   ostream& operator << ( ostream& os, const GDCardInterpreterBase& );

   class GDCardInterpreterBase : public GObject {

   public:

      enum DataCardType { XML };

   public:

      GDCardInterpreterBase( TString dataCardName );
      virtual ~GDCardInterpreterBase();

      virtual Bool_t Interpret() = 0;

      // accessor
      const TString& GetDCardName() const { return m_dataCardName; }

   protected:

      const TString m_dataCardName;

      // aux methods
      Bool_t CheckList( const TList&      , Int_t minLength, TString where = "None" );
      Bool_t CheckList( const GStringList&, Int_t minLength, TString where = "None" );
      Bool_t CheckList( const TList& list, const GStringList& reflist );

      void InterpretScalers( const TString& str, GSclPtrVec_t& scalers );

      static const Bool_t m_debug;
   };
}

#endif
