/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GDCardInterpreterXML                                                  *
 *                                                                                *
 * Description:                                                                   *
 *      Data card Interpreter for XML input files                                 *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GDCardInterpreterXML
#define Gfitter_GDCardInterpreterXML

#include <vector>

#include "TROOT.h"
#include "TXMLNode.h"

#include "Gfitter/GDCardInterpreterBase.h"

class TString;

namespace Gfitter {

   class GDCardInterpreterXML : public GDCardInterpreterBase {

   public:

      GDCardInterpreterXML( const TString& xmlFileName );
      ~GDCardInterpreterXML();

      Bool_t Interpret();      

   private:

      void ReadAttribs     ( TXMLNode* );
      void ReadData        ( TXMLNode* );
      void ReadActions     ( TXMLNode* );
      void ReadCorrelations( TXMLNode* );
   };
}

#endif
