/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GDataBase                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <cmath>
#include <iostream>

#include "TString.h"

#include "Gfitter/GDataBase.h"

using namespace std;

ClassImp(Gfitter::GDataBase)

Gfitter::GDataBase::GDataBase()
   : GObject(),
     m_fitValue( 0 )
{
   InitClassName( "GDataBase" );
}

Gfitter::GDataBase::GDataBase( const GDataBase& other )
   : GObject( other ),
     m_fitValue( other.m_fitValue )
{
   InitClassName( "GDataBase" );
}

Gfitter::GDataBase::~GDataBase()
{}
 
ostream& Gfitter::operator << ( ostream& os, const Gfitter::GDataBase& data )
{
   os << data.GetFitValue() << "(" << data.GetValue() << ")";
   return os;
}

