/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GDataCurve                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Container for parameter curve                                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GDataCurve
#define Gfitter_GDataCurve

#include "TGraph.h"
#include "TH1.h"
#include "TF1.h"
#include "TSpline.h"

#include "Gfitter/GDataBase.h"

namespace Gfitter {

   // MG
   class GParameter;

   class GDataCurve : public GDataBase {

   public:

      GDataCurve();
      GDataCurve( TString fileName, TString histName, TString formula );
      GDataCurve( const GDataCurve& );  
      virtual ~GDataCurve();

      Double_t GetErrGaussp()   const;
      Double_t GetErrGaussm()   const;
      Double_t GetErrTotp()     const;
      Double_t GetErrTotm()     const;
      Double_t GetErrTotSym()   const;

      Double_t GetChiSquared( Double_t fitValue ) const;

      // returns the minimum of the chisq_hist: not precise!
      Double_t GetValue() const;
      Bool_t   SetValue( Double_t v );

      const TH1&     GetHist()  const  { return *m_chi2hist; }
      const TGraph&  GetGraph() const  { return *m_graph; }
      const TSpline& GetSpline() const { return *m_spline; }

      Double_t GetMin()  const; 
      Double_t GetMax()  const;

      // generation along curve
      Double_t GetRndValue( Double_t mean );

      // not used
      Double_t GetGaussRnd( Double_t mean ) const;

   private:
      
      // MG
      // a parameter is exceptoinally allowed to change private members
      friend class GParameter;

      TH1*            m_chi2hist;  // the input histogram holding the chi2 values      
      TGraph*         m_graph;     // the derived TGraph
      Double_t        m_offset;    // offset needed for Toy Analysis
      TSpline*        m_spline;    // the derived TSpline

      ClassDef(GDataCurve,1)         

   };
      
}

#endif
