/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GGSLMinimizer                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      GSL minimizer                                                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GGSLMinimizer
#define Gfitter_GGSLMinimizer

#include "Gfitter/GFitterBase.h"
#include "Fit/Fitter.h"
#include <vector>

namespace Gfitter {

   class GStore;
   class GMinimizerFcn;

   class GGSLMinimizer : public GFitterBase {
      
   public:
      
      GGSLMinimizer(); // default constructor
      GGSLMinimizer(const char* minimizerType, const char* minimizerAlg = "");
      virtual ~GGSLMinimizer();

      // initialise fitter
      void     Initialise();

      // perform fit, and return minimum chi-squared
      Double_t ExecuteFit();
      Double_t GetCurrentChi2();

      void UpdateResults();

      // scan 2D contour
      void DrawContour(GParameter* gpar1, GParameter* gpar2, 
                       Int_t npoints, Double_t dchi2, Double_t* npx, Double_t* npy);

      void setMinimizerType(const char* type) ;
      void setMinimizerAlg(const char* type) ;
      void setEps(Double_t eps) ;

   protected:

      virtual void runPreFitter();
      virtual double runPreFitScan();
      virtual double runPostFitScan();
      virtual void setInitValues() {}
      virtual void doFit();
      virtual void followUpFits();
      virtual void deactivate();
      virtual void reactivate();

      ROOT::Fit::Fitter* _theFitter ;

      // flags 
      Bool_t         m_useImprove;
      Bool_t         m_useMinos; 
      Bool_t         m_isFirstInit;

      std::string    m_minimizerType;
      std::string    m_minimizerAlg;
      Double_t       m_eps;

      GMinimizerFcn* m_fcn;

      Bool_t         m_doPrefitScan;
      Bool_t         m_doPostfitScan;
      Bool_t         m_doCorner;
      Bool_t         m_doRandomize;
      Int_t          m_nfit;

      TString        m_myname;

      std::vector<Double_t> m_bestvalsLoop;    
      Double_t       m_chi2minLoop;
      Double_t       m_edmLoop;

      GParPtrVec_t   m_deactive;
      Bool_t         m_deactivated;
      Bool_t         m_printSummary;

      // Minuit interface to GFitterBase::FCN(...)
      static void IFCN( Int_t& npars, Double_t* gin, Double_t &f, Double_t* fitPars, Int_t iflag );
      
   private:

      static GGSLMinimizer* GetThisPtr();
      static GGSLMinimizer* m_This;       

      ClassDef(GGSLMinimizer,0)

   };   
}

#endif

