/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GGraph2PDF                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "Riostream.h"
#include "TMath.h"
#include "TString.h"

#include "Gfitter/GGraph2PDF.h"

Gfitter::GGraph2PDF::GGraph2PDF( TGraph *chi2, Double_t offset )
{
   // constructor
   InitClassName( "GGraph2PDF" );
   
   m_graph  = chi2;
   m_offset = offset;
}

Gfitter::GGraph2PDF::~GGraph2PDF( void )
{
   // destructor
   delete m_graph;
}

Double_t Gfitter::GGraph2PDF::Evaluate(Double_t* x, Double_t* /* par */ )
{
   Double_t retVal=0.;

   retVal = m_graph->Eval( x[0]-m_offset, 0, "S" );

   // possible due to spline
   //if (retVal < 0) {
      //m_logger << kWARNING << "<Evaluate> Chisq2= "<< retVal << " --> Setting to 0. !! " << GEndl;
   //   retVal = 0.;
   //}
   //else if (isnan(retVal)) {
   //   m_logger << kWARNING << "<Evaluate> Chisq2 is \"nan\" at " << x[0]
   //            << " --> Setting to 1000. !! " << GEndl;
   //   retVal = 1000.;
   //}
 
   return 0.5*TMath::Exp( -retVal/2 );//0.5/TMath::Sqrt( TMath::Pi()*retVal/2 )*TMath::Exp( -retVal/2 );
}
