//////////////////////////////////////////////////////////////////////////////
//
// GMinimizerFcn is am interface class to the ROOT::Math function 
// for minization.
//                                                                                   

#include "Gfitter/GMinimizerFcn.h"
#include "Gfitter/GFitterBase.h"
#include "Gfitter/GParameter.h"

#include <stdlib.h>
#include <iostream>

Gfitter::GMinimizerFcn::GMinimizerFcn(Gfitter::GFitterBase* context, int nDim) :
  _context(context),
  _nDim(nDim)
{ 
  if (_nDim==0) _nDim=context->GetNumOfFitPars();
}

Gfitter::GMinimizerFcn::~GMinimizerFcn()
{
}

ROOT::Math::IBaseFunctionMultiDim* 
Gfitter::GMinimizerFcn::Clone() const 
{  
  return new GMinimizerFcn(_context);
}

double
Gfitter::GMinimizerFcn::DoEval(const double *x) const 
{
  // Set the parameter values for this iteration
  for (int index = 0; index < _nDim; index++) { 
    _context->GetFitPars()[index]->SetFitValue( x[index] );
  }

  // Calculate the function for these parameters
  return _context->GetCurrentChi2();
}

