//////////////////////////////////////////////////////////////////////////////
//
// GMinimizerFcn is am interface class to the ROOT::Math function 
// for minization.
//     

#ifndef G_MINIMIZER_FCN
#define G_MINIMIZER_FCN

#include "Math/IFunction.h"
#include "Fit/ParameterSettings.h"
#include "Fit/FitResult.h"

namespace Gfitter
{
  class GFitterBase;

  class GMinimizerFcn : public ROOT::Math::IBaseFunctionMultiDim {

   public:

    GMinimizerFcn(GFitterBase* context, int nDim=0);
    virtual ~GMinimizerFcn();

    virtual ROOT::Math::IBaseFunctionMultiDim* Clone() const;
    virtual unsigned int NDim() const { return _nDim; }

   private:
  
    virtual double DoEval(const double * x) const;  

    GFitterBase* _context;
    int _nDim;
  };
}

#endif

