/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GMinuitFitter                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Minuit (TFitter) fitter                                                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GMinuitFitter
#define Gfitter_GMinuitFitter

#include "Gfitter/GFitterBase.h"

class TMinuit;

namespace Gfitter {

   class GStore;

   class GMinuitFitter : public GFitterBase {
      
   public:
      
      GMinuitFitter(); // default constructor
      virtual ~GMinuitFitter();

      // initialise fitter
      void     Initialise();

      // perform fit, and return minimum chi-squared
      Double_t ExecuteFit();
      Double_t GetCurrentChi2();

		void UpdateResults();

      // scan 2D contour
      void DrawContour(GParameter* gpar1, GParameter* gpar2, 
                       Int_t npoints, Double_t dchi2, Double_t* npx, Double_t* npy);

   protected:

      TMinuit*       GetMinuit() const { return m_minuit; }
      TMinuit*       m_minuit;

      // flags 
      Bool_t         m_useImprove;
      Bool_t         m_useMinos; 
      Bool_t         m_isFirstInit;

      // Minuit interface to GFitterBase::FCN(...)
      static void IFCN( Int_t& npars, Double_t* gin, Double_t &f, 
                        Double_t* fitPars, Int_t iflag );
      
   private:

      static GMinuitFitter* GetThisPtr();
      static GMinuitFitter* m_This;       

      // wrapped TMinuit routines
      Int_t          ExecuteCommand( const char *command, Double_t *args, Int_t nargs );
      Int_t          GetStats( Double_t&, Double_t&, Double_t&, Int_t&, Int_t& ) const;
      Double_t       GetParameter( Int_t ipar ) const;
      TString        GetParName2( Int_t ipar ) const;
      Int_t          SetParameter( Int_t ipar, const char *parname, Double_t, Double_t, Double_t, Double_t );
      Int_t          GetErrors( Int_t, Double_t&, Double_t&, Double_t&, Double_t& ) const;
      Double_t       GetCovarianceMatrixElement( Int_t i, Int_t j );
      void           Reset();
      Double_t*      m_fitCovMat;

      ClassDef(GMinuitFitter,0)

   };   
}

#endif
