/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GObject                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <iostream>
#include "TRandom.h"
#include "Gfitter/GObject.h"
#include "Gfitter/GInterval.h"
#include "Gfitter/GStore.h"

using namespace std;

ClassImp(Gfitter::GObject)

UInt_t   Gfitter::GObject::m_randomSeed = 0;//65539; // default 65539; 0 => cpu clock time
TRandom* Gfitter::GObject::m_random     = 0;

Gfitter::GObject::GObject() 
   : TObject(),
     m_className( GetName() ),
     m_logger   ( GStore::InitialInstance() ? gStore()->GetMsgLevel() : kINFO )
{
   if (!m_random) m_random = new TRandom( m_randomSeed );
} 

Gfitter::GObject::GObject( const GObject& other )
   : TObject( other ),
     m_className( other.m_className ),
     m_logger   ( other.m_logger.GetSource() )
{}

Gfitter::GObject::~GObject() 
{}

void Gfitter::GObject::InitClassName( const TString& className )
{
   m_className = className;
   m_logger.SetSource( className );
}
                  
void Gfitter::GObject::SetRandomSeed( Int_t seed )
{
   m_randomSeed = seed;
   if (m_random) { delete m_random; m_random = new TRandom( m_randomSeed ); }
}

const TString Gfitter::GObject::GetPrintName() const
{
   return m_logger.GetSource();
}

