/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GParameterRef                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Reference to Parameter container                                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GParameterRef
#define Gfitter_GParameterRef

#include "Rtypes.h"
#include "Gfitter/GReference.h"
#include "Gfitter/GParameter.h"

namespace Gfitter {
   
   class GTheory;

   class GParameterRef : public GReference {

   public:
    
      /**@brief constructor from Parameter
       *
       * @param th the theory which owns this reference
       */
      GParameterRef() :
         GReference(), m_par(0) {}
         
      /**@brief destructor*/
      virtual ~GParameterRef() {}

      // overloading dereferencing operator (both are needed)
      // it is now sort of a smart pointer, no need to change any Theory
      GParameter*  operator->()       { return m_par; }
      GParameter&  operator*()  const { return *m_par; } 

      // returns parameter fit value
      operator Double_t() const { return m_par->GetFitValue(); }

      GParameter** GetAddress()       { return &m_par; }
      void         SetAddress( GParameter *p ) { m_par = p; }
      
   private:

      GParameter* m_par;
   };
}

#endif
