/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GRandomSimplex                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "Gfitter/GRandomSimplex.h"
#include "Gfitter/GVariable.h"
#include "Gfitter/GInterval.h"
#include "Gfitter/GParameter.h"
#include "TRandom.h"

using namespace std;

ClassImp(Gfitter::GRandomSimplex)

Gfitter::GRandomSimplex::GRandomSimplex() 
   : GGSLMinimizer("Minuit","Simplex")
   , m_donotrand(false)
{
   InitClassName( "GRandomSimplex" );
}

Gfitter::GRandomSimplex::~GRandomSimplex()
{
}

void
Gfitter::GRandomSimplex::Initialise()
{
   GGSLMinimizer::Initialise();

   // Randomize starting values?
   if (gStore()->ExistVariable( m_myname+"::NRandomPoints" )) {
      m_doRandomize = true;
      m_nfit = gStore()->GetVariable( m_myname+"::NRandomPoints" )->GetIntValue();
   }

   // hack: do not randomize after all ;-)
   if (gStore()->ExistVariable( m_myname+"::DoNotRandomize" )) {
      m_donotrand = true;
   }

   // Set random seed? Default seed is zero (clock)
   if (gStore()->ExistVariable( m_myname+"::RandomSeed" )) {
     int randomSeed = gStore()->GetVariable( m_myname+"::RandomSeed" )->GetIntValue();
     gStore()->SetVariable( "GfitterFlags::RandomSeed", Form("%d",randomSeed) );
     Gfitter::GObject::SetRandomSeed( randomSeed );
   }

   // set pre- and postfit scan
   m_doPrefitScan  = false;
   m_doPostfitScan = true;
}

void
Gfitter::GRandomSimplex::setInitValues()
{
  if (m_donotrand) return; // hack, to reproduce randomsimplex when needed

  std::vector<ROOT::Fit::ParameterSettings>& parameters = _theFitter->Config().ParamsSettings();

  // apply randomization
  for (Int_t ipar=0; ipar < GetNumOfFitPars(); ++ipar) {
    const GInterval* pfs = GetFitPars()[ipar]->GetPreFitScanRange();
    if (pfs) {
      Double_t min   = pfs->GetMin();
      Double_t width = pfs->GetWidth();
      Double_t x     = min + m_random->Uniform()*width;
      GetFitPars()[ipar]->SetFitValue( x );
      parameters[ipar].SetValue( x ); // initialize the fit here
      m_logger << kINFO << ">> " << GetFitPars()[ipar]->GetParName() << " initial value = " << x << GEndl; 
    }
  }
}

