/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GRandomSimplex                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      GSL minimizer                                                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GRandomSimplex
#define Gfitter_GRandomSimplex

#include "Gfitter/GGSLMinimizer.h"

namespace Gfitter {

   class GRandomSimplex : public GGSLMinimizer {
      
   public:
      
      GRandomSimplex(); // default constructor
      virtual ~GRandomSimplex();

      // initialise fitter
      void Initialise();

   protected:

      virtual void runPreFitter() {}  // turn this off
      virtual void setInitValues();
      virtual void followUpFits() {}  // idem

   private:

      Bool_t m_donotrand;

      ClassDef(GRandomSimplex,0)
   };   
}

#endif

