/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultBase                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      Base class of Results                                                     *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GResultBase
#define Gfitter_GResultBase

#include <vector>

#include "TROOT.h"
#include "TMatrixD.h"

#include "Gfitter/GObject.h"

class TString;

namespace Gfitter {
  
   class GResultBase;
   class GDataBase;
  
   ostream& operator << ( ostream& os, const GResultBase& );

   class GResultBase : public GObject {

   public:

      GResultBase();
      ~GResultBase();

      // accessors
      
      // the parameter name
      TString          GetParName() const { return m_parName; }      
      void             SetParName( const TString& parName ) { m_parName = parName; }

      // the parameter reference data (the measurement)
      const GDataBase* GetRefData() const { return m_refData; }
      void             SetRefData( const GDataBase* d ) { m_refData = d; }

      // the fit value
      virtual Double_t GetValue() const = 0;

      // the chi2min
      virtual Double_t GetChi2Min() const = 0;

      // symmetric gaussian error 
      virtual Double_t GetErrGaussSym ( UInt_t nsigma ) const = 0;

      // asymetric errors, nsigma signed!
      virtual Double_t GetErrGaussAsym( Int_t nsigma ) const = 0;

      // global correlation
      virtual Double_t GetGlobCorr() const = 0; 

      // correlation matrix
      virtual const TMatrixD* GetCorrMat() const { return 0; }

      // fit delay
      virtual const TString GetFitDuration() const { return ""; }

   protected:

      TString          m_parName; // name of parameter
      const GDataBase* m_refData;

      ClassDef(GResultBase,1)
   };
}

#endif
