/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultContainer                                                      *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "Gfitter/GResultContainer.h"

ClassImp(Gfitter::GResultContainer)

Gfitter::GResultContainer::GResultContainer() 
   : GObject(),
     m_resultArray( 0 ),
     m_parameterArray( 0 )
{ 
   InitClassName( "GResultContainer" );

   m_resultArray    = new TObjArray();
   m_parameterArray = new TObjArray();
}

Gfitter::GResultContainer::~GResultContainer() 
{
   m_resultArray   ->Delete(); delete m_resultArray;
   m_parameterArray->Delete(); delete m_parameterArray;
}

const Gfitter::GParameter* Gfitter::GResultContainer::FindParameter( const TString& parName ) const
{
   for (Int_t ipar=0; ipar<GetNumParameters(); ipar++) {
      Gfitter::GParameter* par = (Gfitter::GParameter*)GetParameters().At( ipar ); 
      if (parName == par->GetFullNameWONSpace()) return par;
   }

   return 0;
}
      
