/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultEval                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/

#include <iostream>

#include "Gfitter/GResultEval.h"
#include "Gfitter/GInterval.h"
#include "Gfitter/GMath.h"

using std::cout;
using std::endl;

ClassImp(Gfitter::GResultEval)         

Gfitter::GResultEval::GResultEval()
   : GResultBase(),
     m_value      ( 0 ), 
     m_chi2min    ( 0 ),
     m_errGaussSym( 0 ),
     m_errGaussp  ( 0 ),
     m_errGaussm  ( 0 ),
     m_globalCorr ( 0 ),
     m_covMat     ( 0 ),
     m_corrMat    ( 0 ),
     m_fitDuration( "" )
{
   if (m_covMat != 0) m_corrMat = GMath::GetCorrelationMatrix( *m_covMat );   
}

Gfitter::GResultEval::GResultEval( Double_t value, Double_t chi2min,
                                   Double_t errGaussp,   Double_t errGaussm,
                                   Double_t errGaussSym, Double_t globalCorr,
                                   TMatrixD*& covMat, const TString fitDuration )
   : GResultBase(),
     m_value      ( value ), 
     m_chi2min    ( chi2min ),
     m_errGaussSym( errGaussSym ),
     m_errGaussp  ( errGaussp ),
     m_errGaussm  ( errGaussm ),
     m_globalCorr ( globalCorr ),
     m_covMat     ( covMat ),
     m_corrMat    ( 0 ),
     m_fitDuration( fitDuration )
{
   if (m_covMat != 0) m_corrMat = GMath::GetCorrelationMatrix( *m_covMat );
}

Gfitter::GResultEval::~GResultEval()
{
   ///MB: turn off deletion of covMat, it is owned and deleted by GStore!
   //if (m_covMat!=0) { delete m_covMat;  m_covMat  = 0; }
   if (m_corrMat!=0) { delete m_corrMat; m_corrMat = 0; }
}

Double_t Gfitter::GResultEval::GetErrGaussSym( UInt_t nsigma ) const 
{
   if (nsigma!=1) {
      cout << "using GetErrGausSym with n!=1 !! --> not possible" << endl;
      cout << "returning value for n=1 instead." << endl;      
   }
   return m_errGaussSym; 
}

Double_t Gfitter::GResultEval::GetErrGaussAsym( Int_t nsigma ) const 
{
   if      (nsigma ==  1) return m_errGaussp;
   else if (nsigma == -1) return m_errGaussm;
   else {
      cout << "using GetErrGausSym with nsigma!=1 !! --> not possible" << endl;
      cout << "returning value for nsigma=1 instead." << endl;
   }
   return 0;
}

