/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultWriterBase                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      Base class of ResultWriter                                                *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GResultWriterBase
#define Gfitter_GResultWriterBase

#include <fstream>  // I/O 

#include "TROOT.h"

#include "Gfitter/GObject.h"

namespace Gfitter {

   class GResultWriterBase;
   ostream& operator << ( ostream& os, const GResultWriterBase& );

   class GResultWriterBase : public GObject {

   public:

      GResultWriterBase( TString resultFileName );
      virtual ~GResultWriterBase();

      virtual Bool_t Initialise() = 0;
      virtual Bool_t AddResults( const TString& ) = 0;
      virtual Bool_t Finalise() = 0;

      // accessor
      const TString& GetResultFileName() const { return m_resultFileName; }

   protected:

      const TString m_resultFileName;

		ofstream m_resultFile; 
   };
}

#endif
