/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultWriterLatex                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/

#include "Gfitter/GResultWriterLatex.h"
#include "Gfitter/GParameter.h"
#include "Gfitter/GResultBase.h"

using namespace std;

Gfitter::GResultWriterLatex::GResultWriterLatex( const TString& resultFileName )
   : GResultWriterBase( resultFileName )
{
   InitClassName( "GResultWriterLatex" );
}

Gfitter::GResultWriterLatex::~GResultWriterLatex()
{}

Bool_t Gfitter::GResultWriterLatex::Initialise()
{
   m_resultFile << "\\documentclass[12pt]{article}" << endl;
   m_resultFile << "\\begin{document}" << endl;
   m_resultFile << "\\pagestyle{empty}" << endl;

   const time_t curr=time(0);	
   m_resultFile << "Date: " << ctime(&curr) << "\\\\" << endl;
   m_resultFile << "\\\\" << endl;
   //	m_resultFile << "\\begin{center}" << endl;

   return kTRUE;
}

Bool_t Gfitter::GResultWriterLatex::AddResults( const TString& action )
{ 
   m_resultFile << "\\\\ \\hspace{1cm}  \\\\" << endl;
   m_resultFile << "{\\large\\bf Results of {\\tt " << action << "}:}\\\\ \\\\" << endl;
   m_resultFile << "\\small" << endl;
   m_resultFile << "\\begin{tabular}{|c|c|c|c|c|c|c|}" << endl;
   m_resultFile << "  \\hline" << endl;
   m_resultFile << "        {\\bf Parameter} & {\\bf Value} &  \\multicolumn{3}{|c|}{\\bf Uncertainties} & {\\bf Glob. Corr.} & $\\Delta\\chi^2_{\\rm min}$ \\\\" << endl;
   m_resultFile << "        {\\bf Name}      &             & $\\pm 1\\sigma$ (sym.) & -1$\\sigma$ & +1$\\sigma$ & & \\\\" << endl;
   m_resultFile << "  \\hline\\hline" << endl;

   const GParPtrVec_t& fp = gStore()->GetActiveParameters();	
   for (GParPtrVec_t::const_iterator par = fp.begin(); par != fp.end(); par++) {

      // print the result for those parameters which have a result
      if ((*par)->GetResult()) {
         m_resultFile << (*par)->GetParName() << " & "
                      << (*par)->GetResult()->GetValue()  << " & " 
                      << (*par)->GetResult()->GetErrGaussSym(1) << " & "
                      << (*par)->GetResult()->GetErrGaussAsym(1) << " & "
                      << (*par)->GetResult()->GetErrGaussAsym(-1) << " & "
                      << (*par)->GetResult()->GetGlobCorr() << " & " 
                      << (*par)->GetResult()->GetChi2Min() << " \\\\" 
                      << endl;
      }      
   }
   m_resultFile << "      \\hline" << endl;
   m_resultFile << " \\end{tabular} \\\\" << endl;

   return kTRUE;
}

Bool_t Gfitter::GResultWriterLatex::Finalise()
{
   m_resultFile << "\\end{document}" << endl;
	
   m_resultFile.flush();
   m_resultFile.close(); 	

   return kTRUE;
}
