/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultWriterRoot                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <iostream>
#include <iomanip>
#include <ios>

#include "Gfitter/GResultWriterRoot.h"
#include "Gfitter/GResultBase.h"
#include "Gfitter/GParameter.h"
#include "Gfitter/GResultContainer.h"

using namespace Gfitter;

Gfitter::GResultWriterRoot::GResultWriterRoot()
   : GResultWriterBase( "" ),
     m_resultContainer( 0 )
{
   // open the result file
   InitClassName( "GResultWriterRoot" );
}

Gfitter::GResultWriterRoot::~GResultWriterRoot()
{
   if (m_resultContainer) delete m_resultContainer;
}

Bool_t Gfitter::GResultWriterRoot::Initialise()
{
   return kTRUE;
}

Bool_t Gfitter::GResultWriterRoot::AddResults( const TString& action )
{
   using namespace std;

   if (action == "Scan1D" || action == "Evaluate" || action == "EvaluateToy") {
      
      // create a container for the results
      if (m_resultContainer) delete m_resultContainer; 
      m_resultContainer = new GResultContainer();

      // fit parameters
      const GParPtrVec_t& fp = gStore()->GetParameters();	
      for (GParPtrVec_t::const_iterator par = fp.begin(); par != fp.end(); par++) {

         // print the result for those parameters which have a result
         if ((*par)->GetResult()) {
            m_resultContainer->AddResult( (*par)->GetResult() );
         }
      }

      if (m_resultContainer->GetNumResults() <= 0) m_logger << kFATAL << "No parameter with result found! " << GEndl;

      // all active parameters
      const GParPtrVec_t& vu = gStore()->GetActiveParameters();
      for  (GParPtrVec_t::const_iterator it = vu.begin(); it != vu.end(); ++it){
         // update comparison cache
         (*it)->UpdatePersistencyCache();

         // and add the parameter
         m_resultContainer->AddParameter( *it );
      }

      if (m_resultContainer->GetNumParameters() <= 0) m_logger << kFATAL << "No parameters found! " << GEndl;
         
      // write to target file (assumes that target ROOT file exists)
      m_resultContainer->Write( TString("GResultContainer") + "_" + action );
   } 
   else {
      m_logger << kINFO << "no GResults implemented for action: " << action << GEndl;
   }

   return kTRUE;
}   

Bool_t Gfitter::GResultWriterRoot::Finalise()
{
   return kTRUE;   
}

