/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultWriterRoot                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      Dump results into ROOT target file                                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GResultWriterRoot
#define Gfitter_GResultWriterRoot

#include <vector>

#include "Gfitter/GResultWriterBase.h"

namespace Gfitter {

   class GResultContainer;

   class GResultWriterRoot : public GResultWriterBase {

   public:

      GResultWriterRoot();
      ~GResultWriterRoot();

		Bool_t Initialise();      
      Bool_t AddResults( const TString& );
		Bool_t Finalise();      

   private:

      GResultContainer* m_resultContainer;
   };
}

#endif
