/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GRootClassFactory                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      Container for parameter value                                             *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <iostream>

#include "TString.h"
#include "TROOT.h"
#include "TClass.h"

#include "GRootClassFactory.h"
#include "GMsgLogger.h"

using std::cout;
using std::endl;

Gfitter::GMsgLogger* Gfitter::GRootClassFactory::m_logger = 0;

void* Gfitter::GRootClassFactory::CreateObject( const TString& className, const TString& inheritsFrom )
{
   if (m_logger == 0) m_logger = new GMsgLogger( "GRootClassFactory" );

   void* object = 0;
   TClass* tmp = gROOT->GetClass( className );
   if (tmp) {
      if (inheritsFrom.Sizeof() == 0 || tmp->InheritsFrom( inheritsFrom )) {	
         object = tmp->New();
         if (!object) {
            *m_logger << kFATAL << "Class \"" << className 
                      << "\" could not be instantiated via TClass::New()" << GEndl;
         }
      }  
      else {
         *m_logger << kFATAL << "Class \"" << className << "\" does not inherit from class \""
                   << inheritsFrom << "\"" << GEndl;
      }
   }
   else {
      *m_logger << kFATAL << "Class \"" << className << "\" could not be instantiated" << GEndl;
   }   

   return object;
}

const TString Gfitter::GRootClassFactory::FindClassNameInString( const TString& str, const TString& inheritsFrom )
{
   for (Int_t length=1; length<str.Sizeof(); length++) {
      for (Int_t index=0; index<str.Sizeof()-length; index++) {
         TString substr = str(index,length);
         if (substr.Contains("::") || !substr.Contains(":")) {
            cout << substr << endl;
            TClass* tmp = gROOT->GetClass( substr );
            if (tmp) {
               if (inheritsFrom.Sizeof() == 0 || tmp->InheritsFrom( inheritsFrom )) {	
                  return substr;               
               }
            }
         }
      }
   }

   return "";
}
