/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GRootClassFactory                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      Pure static factory class for ROOT class objects                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
//
// pure static factory class
//

#ifndef Gfitter_GRootClassFactory
#define Gfitter_GRootClassFactory

class TString;

namespace Gfitter {

   class GMsgLogger;

   class GRootClassFactory {
      
   public:
      
      // create a class
      static void* CreateObject( const TString& className, const TString& inheritsFrom = "" );
      
      // find a class within a larger string
      static const TString FindClassNameInString( const TString&, const TString& inheritsFrom );
      
   private:
      
      static GMsgLogger* m_logger;
   };
}

#endif
