/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GRungeKutta                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      Runge-Kutta Method to solve differential equation                         *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GRungeKutta
#define Gfitter_GRungeKutta

#include "GObject.h"

namespace Gfitter {
   
   class GRungeKutta : public GObject {
      
   public:
      
      GRungeKutta(Double_t (*rungeVal)( Double_t, Double_t ), 
                  Int_t    maxIterations = 100 );
      virtual ~GRungeKutta( void );
      
      // returns y Value at xend
      Double_t GetYEndValue(  Double_t xStart, Double_t yStart , Double_t xEnd );
      
   private:
      
      Int_t    m_MaxIter; // maximum number of iterations
      
      // function pointer
      Double_t (*m_GetRungeVal)( Double_t, Double_t );

   };

}

#endif

